/******************************************************************************
* (C) Copyright 2002 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#include "AgtPortSelector.h"
#include "AgtPCIEControl.h"

// Values from boards Config space at offset 0 (vendor/device id)
#define AGT_VENDID      0x15bc
#define AGT_PROBE_DEVID 0x4305 // 0x2960
#define AGT_PTC_DEVID   0x2969

CAgtPortSelector::CAgtPortSelector()
{
  myController = new CAgtPCIEControl();
}

CAgtPortSelector::~CAgtPortSelector()
{
  delete myController;
  myController = NULL;
}

void CAgtPortSelector::OSHandleGet( AgtPortHandleT porthandle, HANDLE * osHandle )
{
  myController->OSHandleGet( porthandle, osHandle );
}

void CAgtPortSelector::ConnectPort( UInt32 deviceId, AgtPortHandleT* portHandle )
{
  myController->ConnectPort( deviceId, portHandle );
}

void CAgtPortSelector::DisconnectPort( AgtPortHandleT myPortHandle )
{
  myController->DisconnectPort( myPortHandle );
}

void CAgtPortSelector::DeviceIdGet( UInt16 index, UInt32* deviceId )
{
  if( deviceId == NULL )
  {
    AGT_THROW( "DeviceIdGet: Invalid NULL pointer passed (deviceId)." );
  }

  // Look for probe boards first
  // Returns index as deviceId under Linux
  DeviceIdGet( AGT_VENDID, AGT_PROBE_DEVID, index, deviceId);

#if 0
  if (*deviceId==AGT_INVALID_DEVID)
  {
    // No probe boards found. Look for PTCs now:
    DeviceIdGet(AGT_VENDID,AGT_PTC_DEVID,index,deviceId);
  }
#endif
}

void CAgtPortSelector::DeviceIdGet( UInt16 vendId, UInt16 devId, UInt16 index, UInt32* deviceId )
{
  myController->DeviceIdGet( vendId, devId, index, deviceId );
}